<?php
require_once '../includes/functions.php';
require_once '../config/db.php';
function getFaviconPath() {
    global $pdo;
    $stmt = $pdo->prepare("SELECT setting_value FROM store_settings WHERE setting_key = 'store_favicon' AND setting_group = 'store_info' LIMIT 1");
    $stmt->execute();
    $faviconPath = $stmt->fetchColumn();
    
    // If favicon exists in database and file exists
    if ($faviconPath && file_exists($_SERVER['DOCUMENT_ROOT'] . '/POS/' . $faviconPath)) {
        return $faviconPath;
    }
    
    // Default favicon path if none is set
    return 'assets/images/favicon.ico';
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($pageTitle) ? $pageTitle . ' - ' : ''; ?>POS System</title>
    <!-- Favicon -->
    <?php $faviconPath = getFaviconPath(); ?>
    <link rel="icon" type="image/x-icon" href="<?php echo htmlspecialchars($faviconPath); ?>">
    <link rel="shortcut icon" type="image/x-icon" href="<?php echo htmlspecialchars($faviconPath); ?>">
    <!-- CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
    <!-- Session Timeout Management -->
    <script src="../js/session_timeout.js"></script>
    <style>
        body { 
            background: linear-gradient(135deg, #f8fafc 0%, #e0e7ff 100%); 
            font-family: 'Inter', sans-serif; 
        }
        .card { 
            border-radius: 16px; 
            box-shadow: 0 2px 12px rgba(37,99,235,0.06); 
            border: none; 
        }
        .card-header { 
            background: none; 
            border-bottom: none; 
        }
        .btn-primary, .btn-warning, .btn-info, .btn-danger { 
            border-radius: 8px; 
            font-weight: 600; 
        }
        .table { 
            background: #fff; 
            border-radius: 12px; 
            overflow: hidden; 
        }
        .table th, .table td { 
            vertical-align: middle; 
        }
        .table-striped > tbody > tr:nth-of-type(odd) { 
            background-color: #f3f4f6; 
        }
        .modal-content { 
            border-radius: 16px; 
        }
        .form-label { 
            font-weight: 600; 
            color: #2563eb; 
        }
        .modal-title { 
            color: #2563eb; 
            font-weight: 700; 
        }
    </style>
</head>
<body>
    <?php include '../navbar.php'; ?>
    <div class="container-fluid py-4">
        <div class="row">
            <?php include '../sidebar.php'; ?>
            <!-- Main Content -->
            <div class="col-md-10 ms-sm-auto px-md-4">
                <?php include '../topbar.php'; ?>
            </div>
        </div>
    </div>
</body>
</html> 